#ifndef __THREADTOOLS_H__
#define __THREADTOOLS_H__
/*------------------------------------------------------------------------
  **** BEGIN LICENSE BLOCK ****
  Version: MPL 1.1/GPL 2.0/LGPL 2.1
  Copyright(c) 2004-2010 Created by Eric Fredericksen (www.pttpsystems.com)
  All Rights Reserved.

  This program are subject to the Mozilla Public License Version
  1.1 (the "License"); you may not use this file except in compliance with
  the License. You may obtain a copy of the License at
  http://www.mozilla.org/MPL/

  This program is free software. Software distributed under the License
  is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND,
  either express or implied. See the License for the specific language
  governing rights and limitations under the License.

  Alternatively, the contents of this file may be used under the terms of
  either the GNU General Public License Version 2 or later (the "GPL"), or
  the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
  in which case the provisions of the GPL or the LGPL are applicable instead
  of those above. If you wish to allow use of your version of this file only
  under the terms of either the GPL or the LGPL, and not to allow others to
  use your version of this file under the terms of the MPL, indicate your
  decision by deleting the provisions above and replace them with the notice
  and other provisions required by the GPL or the LGPL. If you do not delete
  the provisions above, a recipient may use your version of this file under
  the terms of any one of the MPL, the GPL or the LGPL.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59 Temple
  Place, Suite 330, Boston, MA 02111-1307 USA
  **** END LICENSE BLOCK ****
------------------------------------------------------------------------*/

//==================================================
// use this for auto scope protection for threading
//==================================================
class CScopeProtector
{
protected:
	CRITICAL_SECTION & m_roCS;

public:
	CScopeProtector(CRITICAL_SECTION & _roCS) 
		: m_roCS(_roCS)
	{	
		EnterCriticalSection(&m_roCS);	
	}
	virtual ~CScopeProtector() 
	{ 
		LeaveCriticalSection(&m_roCS); 
	}
};


//==================================================
//
//==================================================
class CTaskThread
{
public:

	enum
	{
		INITIALIZED,
		RELEASED,
		WAITING,
		ASSIGNED,
		RUNNING,
		DEAD
	} threadstate;

protected:

	// debugging
	HANDLE m_hThreadHandle;
	DWORD m_dwThreadID;

	// for blocking and waiting for work
	HANDLE m_hGateKeeper;

	// for keeping track of where we are, for others to query
	DWORD m_dwThreadState;

public:

	CTaskThread(void);
	virtual ~CTaskThread();

	DWORD GetThreadState(void) { return(m_dwThreadState); }

	bool InitSuccess(void) { return( m_hThreadHandle && m_hGateKeeper ); }

	// override this function to implement your work
	virtual DWORD VirtualCallbackFunction(void);

	// this is the function that will be spawned
	static int __cdecl TaskThread( void * _pvMyThisPointer );

	typedef void( __cdecl *pFNStartAddress )( void * );

	HANDLE StartThread(void);

	// opens gate for thread to try to do work
	void ReleaseThread(void);

};





#endif // __THREADTOOLS_H__
